package editor;

import game.CustomImageDataII;
import game.PonyPanel;

import java.awt.FileDialog;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ListedImage {
	
	private Image image;
	private String fileName;
	
	public ListedImage(String theFileName, Image theImage) {
		fileName = theFileName;
		image = theImage;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public Image getImage() {
		return image;
	}

	public void setImage(Image image) {
		this.image = image;
	}
	
	public String toString() {
		if(fileName == null) {
			return null;
		}
		
		int index = Math.max(fileName.lastIndexOf('\\'), fileName.lastIndexOf('/'));
		
		if(index == -1 || index == (fileName.length() - 1))
			return fileName;
		else
			return fileName.substring(index + 1);
		
		
	}
	
	
	public static ListedImage letUserSelectImage(String title, JFrame parent) {
		
		ListedImage returnValue = new ListedImage(null, null);
		
		FileDialog fd = new FileDialog(parent, title, FileDialog.LOAD);
		
//		System.out.println("about to called fd.setVisible...will it work?");
		
		fd.setVisible(true);
		
//		System.out.println("it just returned from fd.setVisible...file is:  <<" + fd.getFile() + ">>, directory is: <<" + fd.getDirectory() + ">>");
		
		if(fd.getFile() == null || fd.getDirectory() == null) {
//			System.out.println("user clicked cancel!");
			return null;
		}
		
		String fullFileName = fd.getDirectory() + fd.getFile();
		
		Image theImage = null;
		
		File theFile = new File(fullFileName);
		
		if(!theFile.exists()) {
//			System.out.println("file doesn't exist...I should really add a 'hey doofus!' dialog for this one...");
			
			JOptionPane.showMessageDialog(null, "The specified file did not exist.", "File Error", JOptionPane.ERROR_MESSAGE);
			
			return null;
		}
		
		try {
			theImage = ImageIO.read(theFile);
		} catch (IOException e) {
			// TODO add a dialog to this one.
//			e.printStackTrace();
			
//			System.err.println("there was an IOException while reading this pooch...");
			JOptionPane.showMessageDialog(null, "Error while reading file:  " + e.getMessage(), "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(theImage == null) {
			JOptionPane.showMessageDialog(null, "The given file was not a readable image format:  " + fullFileName, "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		returnValue.setImage(theImage);
		returnValue.setFileName(fullFileName);
		
		
		return returnValue;
		
	}
	
	

	public static ListedImage letUserSelectImage(String title, JDialog parent, BackgroundPanel bgp) {
		
		ListedImage returnValue = new ListedImage(null, null);
		
		FileDialog fd = new FileDialog(parent, title, FileDialog.LOAD);
		
//		System.out.println("about to called fd.setVisible...will it work?");
		
		fd.setVisible(true);
		
//		System.out.println("it just returned from fd.setVisible...file is:  <<" + fd.getFile() + ">>, directory is: <<" + fd.getDirectory() + ">>");
		
		if(fd.getFile() == null || fd.getDirectory() == null) {
//			System.out.println("user clicked cancel!");
			return null;
		}
		
		String fullFileName = fd.getDirectory() + fd.getFile();
		
		BufferedImage theImage = null;
		
		File theFile = new File(fullFileName);
		
		if(!theFile.exists()) {
//			System.out.println("file doesn't exist...I should really add a 'hey doofus!' dialog for this one...");
			
			JOptionPane.showMessageDialog(null, "The specified file did not exist.", "File Error", JOptionPane.ERROR_MESSAGE);
			
			return null;
		}
		
		try {
			theImage = ImageIO.read(theFile);
		} catch (IOException e) {
			// TODO add a dialog to this one.
//			e.printStackTrace();
			
//			System.err.println("there was an IOException while reading this pooch...");
			JOptionPane.showMessageDialog(null, "Error while reading file:  " + e.getMessage(), "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(theImage == null) {
			JOptionPane.showMessageDialog(null, "The given file was not a readable image format:  " + fullFileName, "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		
//		System.out.println("resizeing it...");
		
		CustomImageDataII resizedImage = new CustomImageDataII(theImage, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT, null, bgp, fullFileName, false);
		
		returnValue.setImage(resizedImage.getImage());
		returnValue.setFileName(fullFileName);
		
		
		return returnValue;
		
	}
	
}
